<?php
session_start();

if (!isset($_SESSION['token']) || !isset($_SESSION['usuario'])) {
    http_response_code(403);
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

$token = $_SESSION['token'];
$cuenta = $_POST['cuenta'] ?? null;
$tipo = $_POST['tipo'] ?? null;
$ultimos = $_POST['ultimos'] ?? null;
$bloquear_str = $_POST['bloquear'] ?? null;

if (!$cuenta || !$tipo || !$ultimos || is_null($bloquear_str)) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos para bloquear/desbloquear']);
    exit;
}

// Convertir el string 'true' o 'false' a booleano correctamente
$bloqueado = ($bloquear_str === 'true');

$url = 'https://www.prexcard.com/api/cuentas_set_bloqueo';

$headers = [
    'Content-Type: application/json',
    'Device-Serial: unknown',
    'Device-Version: 16.0.2',
    'Device-App-Version: 10.63.02',
    'Authorization: Bearer ' . $token,
    'Accept: */*',
    'Device-Platform: iOS',
    'Accept-Language: es-BV;q=1',
    'Device-Model: iPhone10,6',
    'Device-Manufacturer: Apple',
    'User-Agent: Prex/10.63.02 (iPhone; iOS 16.0.2; Scale/3.00)',
    'Device-Firebase-Token: cCxslJvsOkxcvlyaoTAsaA:APA91bEXGAxWhk6iAqQOiVkrJEG9B7v8GMBB57LVArrDy1WeJWY2ycZoneOrY4MBE1e8kOHMbTa355_kxDfy92IopLPtg6KtWya16w0KBIXX71HdRzgbMjs',
    'Device-Uuid: 606588F5-3BCA-4D63-B613-F2D9617CA09A'
];

$data = [
    'bloqueado' => $bloqueado,
    'cuenta' => (int)$cuenta,
    'tipo' => $tipo,
    'ultimos' => $ultimos
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);

if ($response === false) {
    http_response_code(500);
    echo json_encode(['error' => 'Error en la conexión cURL: ' . curl_error($ch)]);
    curl_close($ch);
    exit;
}

curl_close($ch);

header('Content-Type: application/json');
echo $response;
