<?php
session_start();

if (!isset($_SESSION['token']) || !isset($_SESSION['usuario'])) {
    header('Location: login.php');
    exit;
}

$token = $_SESSION['token'];
$id_usuario = $_SESSION['usuario']['DatosPersonales']['id'];
$nombre = $_SESSION['usuario']['DatosPersonales']['nombre1'] . ' ' . $_SESSION['usuario']['DatosPersonales']['apellido1'];
$documento = $_SESSION['usuario']['DatosPersonales']['documento'] ?? ''; // Asumiendo que aquí está el documento
$tipo_documento = $_SESSION['usuario']['DatosPersonales']['tipo_documento'] ?? 'CI'; // O el tipo que uses

// --- Obtener datos de tarjeta ---
$url_tarjetas = 'https://www.prexcard.com/api/listado_tarjetas';

$headers = [
    'Content-Type: application/json',
    'Device-Serial: unknown',
    'Device-Version: 16.0.2',
    'Device-App-Version: 10.63.02',
    'Authorization: Bearer ' . $token,
    'Accept: */*',
    'Device-Platform: iOS',
    'Accept-Language: es-BV;q=1',
    'Device-Model: iPhone10,6',
    'Device-Manufacturer: Apple',
    'User-Agent: Prex/10.63.02 (iPhone; iOS 16.0.2; Scale/3.00)',
    'Device-Firebase-Token: cCxslJvsOkxcvlyaoTAsaA:APA91bEXGAxWhk6iAqQOiVkrJEG9B7v8GMBB57LVArrDy1WeJWY2ycZoneOrY4MBE1e8kOHMbTa355_kxDfy92IopLPtg6KtWya16w0KBIXX71HdRzgbMjs',
    'Device-Uuid: 606588F5-3BCA-4D63-B613-F2D9617CA09A'
];

$data_tarjetas = ['id_usuario' => $id_usuario];

$ch = curl_init($url_tarjetas);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_tarjetas));
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response_tarjetas = curl_exec($ch);
curl_close($ch);

$result_tarjetas = json_decode($response_tarjetas, true);
$tarjeta = $result_tarjetas['listado_tarjetas'][0] ?? null;

// --- Obtener saldo de cuenta ---
$saldo_pesos = null;
$saldo_dolares = null;

if ($tarjeta) {
    $url_saldo = 'https://www.prexcard.com/api/estado_cuenta_saldos';

    // Datos que se envían a la API de saldo
    $data_saldo = [
        'Token' => $token,
        'NroCuenta' => (int)$tarjeta['cuenta'],
        'Documento' => $documento,
        'TipoDocumento' => $tipo_documento
    ];

    $ch = curl_init($url_saldo);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data_saldo));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response_saldo = curl_exec($ch);
    curl_close($ch);

    $result_saldo = json_decode($response_saldo, true);

    if ($result_saldo && isset($result_saldo['error']) && $result_saldo['error'] === 0) {
        $saldo_pesos = $result_saldo['SaldoPesos'];
        $saldo_dolares = $result_saldo['SaldoDolares'];
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Dashboard</title>
    <style>
        /* Tu CSS existente */
        body {
            background: #f4f6f9;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 40px;
        }
        .container {
            max-width: 600px;
            background: #fff;
            padding: 30px;
            margin: auto;
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
            color: #333;
        }
        .tarjeta-info {
            background-color: #f0f4f8;
            padding: 20px;
            margin-top: 25px;
            border-radius: 8px;
        }
        .tarjeta-info p {
            margin: 10px 0;
            color: #555;
        }
        .saldo-info {
            background-color: #dff0d8;
            color: #3c763d;
            padding: 15px;
            margin-top: 15px;
            border-radius: 8px;
            font-weight: bold;
            font-size: 16px;
        }
        .botones {
            margin-top: 20px;
            text-align: center;
        }
        .botones form {
            display: inline-block;
            margin: 0 10px;
        }
        .botones button {
            padding: 10px 20px;
            font-weight: bold;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .ver-btn {
            background-color: #1c92d2;
            color: white;
        }
        .bloquear-btn {
            background-color: #e74c3c;
            color: white;
        }
        .desbloquear-btn {
            background-color: #2ecc71;
            color: white;
        }
        .salir-btn {
            margin-top: 40px;
            display: block;
            text-align: center;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Bienvenida, <?php echo htmlspecialchars($nombre); ?></h2>

    <?php if ($tarjeta): ?>
        <div class="tarjeta-info">
            <p><strong>Nombre en tarjeta:</strong> <?php echo htmlspecialchars($tarjeta['nombre']); ?></p>
            <p><strong>Tipo:</strong> <?php echo htmlspecialchars($tarjeta['tipo']); ?></p>
            <p><strong>Últimos dígitos:</strong> <?php echo htmlspecialchars($tarjeta['ultimos']); ?></p>
            <p><strong>Cuenta:</strong> <?php echo htmlspecialchars($tarjeta['cuenta']); ?></p>
            <p><strong>Estado:</strong> <?php echo $tarjeta['esta_bloqueada'] ? '🔒 Bloqueada' : '✅ Activa'; ?></p>
        </div>

        <?php if (!is_null($saldo_pesos) && !is_null($saldo_dolares)): ?>
            <div class="saldo-info">
                Saldo Pesos: $<?php echo number_format($saldo_pesos, 2); ?><br>
                Saldo Dólares: $<?php echo number_format($saldo_dolares, 2); ?>
            </div>
        <?php endif; ?>

        <div class="botones">
            <!-- Botón VER TARJETA -->
            <form action="ver_tarjeta.php" method="POST" target="_blank">
                <input type="hidden" name="ultimos" value="<?php echo htmlspecialchars($tarjeta['ultimos']); ?>">
                <button class="ver-btn" type="submit">👁️ Ver tarjeta</button>
            </form>

            <!-- Botón BLOQUEAR / DESBLOQUEAR -->
            <form action="bloquear_tarjeta.php" method="POST">
                <input type="hidden" name="cuenta" value="<?php echo htmlspecialchars($tarjeta['cuenta']); ?>">
                <input type="hidden" name="tipo" value="<?php echo htmlspecialchars($tarjeta['tipo']); ?>">
                <input type="hidden" name="ultimos" value="<?php echo htmlspecialchars($tarjeta['ultimos']); ?>">
                <input type="hidden" name="bloquear" value="<?php echo $tarjeta['esta_bloqueada'] ? 'false' : 'true'; ?>">
                <button class="<?php echo $tarjeta['esta_bloqueada'] ? 'desbloquear-btn' : 'bloquear-btn'; ?>" type="submit">
                    <?php echo $tarjeta['esta_bloqueada'] ? '🔓 Desbloquear' : '🔒 Bloquear'; ?>
                </button>
            </form>
        </div>
    <?php else: ?>
        <p>No se encontró ninguna tarjeta para este usuario.</p>
    <?php endif; ?>

    <div class="salir-btn">
        <a href="logout.php"><button class="bloquear-btn">Cerrar sesión</button></a>
    </div>
</div>

</body>
</html>
