<?php

// Archivos de entrada y salida
$archivoEntrada = 'entrada.txt';
$archivoSalida = 'salida.txt';

// Abrir el archivo de entrada
$lineas = file($archivoEntrada, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

$resultado = [];

foreach ($lineas as $linea) {
    // Obtener la parte después del último "/"
    $partes = explode('/', $linea);
    $ultimoSegmento = end($partes); // por ejemplo: "authenticationendpoint/login.do:51146479:ma19062018@"

    // Extraer solo la parte después del primer ":" en ese segmento
    $subPartes = explode(':', $ultimoSegmento, 2);

    if (count($subPartes) === 2) {
        $resultado[] = $subPartes[1]; // esto será: 51146479:ma19062018@
    }
}

// Guardar resultados en el archivo de salida
file_put_contents($archivoSalida, implode(PHP_EOL, $resultado));

echo "Hecho. Se guardaron las credenciales en '$archivoSalida'.\n";
