<?php
session_start();

if (!isset($_SESSION['token']) || !isset($_SESSION['usuario'])) {
    http_response_code(403);
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

$token = $_SESSION['token'];
$id_usuario = $_SESSION['usuario']['DatosPersonales']['id'];
$ultimos = $_POST['ultimos'] ?? null;

if (!$ultimos) {
    echo json_encode(['error' => 'Faltan los últimos dígitos']);
    exit;
}

$url = 'https://www.prexcard.com/api/get_datos_tarjeta_virtual';

$headers = [
    'Content-Type: application/json',
    'Device-Serial: unknown',
    'Device-Version: 16.0.2',
    'Device-App-Version: 10.63.02',
    'Authorization: Bearer ' . $token,
    'Accept: */*',
    'Device-Platform: iOS',
    'Accept-Language: es-BV;q=1',
    'Device-Model: iPhone10,6',
    'Device-Manufacturer: Apple',
    'User-Agent: Prex/10.63.02 (iPhone; iOS 16.0.2; Scale/3.00)',
    'Device-Firebase-Token: cCxslJvsOkxcvlyaoTAsaA:APA91bEXGAxWhk6iAqQOiVkrJEG9B7v8GMBB57LVArrDy1WeJWY2ycZoneOrY4MBE1e8kOHMbTa355_kxDfy92IopLPtg6KtWya16w0KBIXX71HdRzgbMjs',
    'Device-Uuid: 606588F5-3BCA-4D63-B613-F2D9617CA09A'
];

$data = [
    'ultimos' => $ultimos,
    'id_usuario' => $id_usuario
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
curl_close($ch);

$result = json_decode($response, true);

if (!$result || isset($result['error']) && $result['error'] !== 0) {
    echo "<p>Error al obtener los datos de la tarjeta.</p>";
    exit;
}

// Variables seguras para mostrar
$number = htmlspecialchars($result['number']);
$expiry_date = htmlspecialchars($result['expiry_date']);
$current_cvc = htmlspecialchars($result['current_cvc']);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <title>Datos de la Tarjeta Virtual</title>
    <style>
        body {
            background: #f7f9fc;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .card {
            background: white;
            padding: 30px 40px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            max-width: 350px;
            width: 100%;
            text-align: center;
        }
        .card h2 {
            margin-bottom: 20px;
            color: #333;
        }
        .card p {
            font-size: 18px;
            margin: 10px 0;
            color: #555;
            letter-spacing: 1.2px;
        }
        .label {
            font-weight: bold;
            color: #777;
            font-size: 14px;
            margin-top: 20px;
            text-transform: uppercase;
            letter-spacing: 1.5px;
        }
        .close-btn {
            margin-top: 25px;
            padding: 10px 20px;
            background: #1c92d2;
            border: none;
            color: white;
            border-radius: 8px;
            cursor: pointer;
            font-weight: bold;
            text-decoration: none;
            display: inline-block;
        }
        .close-btn:hover {
            background: #0f6fb2;
        }
    </style>
</head>
<body>
    <div class="card">
        <h2>Tarjeta Virtual</h2>
        <div>
            <p><span class="label">Número:</span><br> <?php echo $number; ?></p>
            <p><span class="label">Fecha de expiración:</span><br> <?php echo $expiry_date; ?></p>
            <p><span class="label">CVC actual:</span><br> <?php echo $current_cvc; ?></p>
        </div>
        <a href="dashboard.php" class="close-btn">Cerrar</a>
    </div>
</body>
</html>
